/*
 * @(#)ComparePertModelsAction.java  1.0  15. Februar 2006
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.pert;

import java.awt.event.*;
import javax.swing.*;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.util.ResourceBundleUtil;
/**
 * ComparePertModelsAction.
 * 
 * 
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 15. Februar 2006 Created.
 */
public class ComparePertModelsAction extends AbstractViewAction {
    //private PertView project;
    public final static String ID = "verify";
    
    /** Creates a new instance. */
    public ComparePertModelsAction(Application app, View v) {
       super(app,v);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.pert.Labels");
        labels.configureAction(this, ID);
       // this.project = p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PertView project = (PertView) getActiveView();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.pert.Labels");
        String message = project.getProblemModel().describeDifferencesTo(project.getSolutionModel());
        if (message == null) {
            message = labels.getString("noDiffsFound");
        }
        JOptionPane.showMessageDialog(project.getComponent(), message
                );
    }
    
}
